/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.udp.wifi.set;

import android.text.TextUtils;
import com.gprinter.udp.CommandUDP;
import com.gprinter.udp.Response;
import com.gprinter.udp.wifi.set.ResultResp;

public class SettingWifiModeCommand
extends CommandUDP {
    private boolean valid = false;
    private String mode;

    public SettingWifiModeCommand(String mode) {
        if (TextUtils.isEmpty((CharSequence)mode)) {
            this.valid = false;
        } else {
            this.valid = true;
            this.mode = mode;
        }
    }

    @Override
    public byte[] getCommand() {
        if (!this.valid) {
            return null;
        }
        return this.getAT_WMODE(this.mode).getBytes();
    }

    @Override
    public Response resolveResponseData(long uuid, byte[] data) {
        try {
            if (data != null) {
                String response = new String(data);
                ResultResp resultResp = new ResultResp();
                if (response.contains("+ok")) {
                    resultResp.setResult(true);
                } else {
                    resultResp.setResult(false);
                }
                return resultResp;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getAT_WMODE(String str) {
        if (!str.equals("")) {
            String cmd = "AT+WMODE=";
            cmd = cmd + str;
            cmd = cmd + "\r";
            return cmd;
        }
        return "";
    }
}

